/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.profile;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.request.AddFriendRequest;
import net.creeperhost.minetogether.lib.chat.request.ListFriendsRequest;
import net.creeperhost.minetogether.lib.chat.request.ListFriendsResponse;
import net.creeperhost.minetogether.lib.chat.request.ProfileRequest;
import net.creeperhost.minetogether.lib.chat.request.ProfileResponse;
import net.creeperhost.minetogether.lib.chat.request.RemoveFriendRequest;
import net.creeperhost.minetogether.lib.chat.util.HashLength;
import net.creeperhost.minetogether.lib.util.AbstractWeakNotifiable;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.ColUtils;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.StreamableIterable;
import net.creeperhost.minetogether.repack.net.covers1624.quack.util.LazyValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ProfileManager
extends AbstractWeakNotifiable<ProfileManagerEvent> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService FRIEND_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Friends Thread %d").setDaemon(true).build());
    private final ScheduledExecutorService SCHEDULED_FRIEND_EXECUTOR = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MT Scheduled Friends Update Thread %d").setDaemon(true).build());
    private final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Profile Update Thread %d").setDaemon(true).build());
    private final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("MT Scheduled Profile Update Thread %d").setDaemon(true).build());
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final LazyValue<Profile> ownProfile;
    private final List<FriendRequest> friendRequests = new LinkedList<FriendRequest>();
    private int friendCookie;
    private boolean friendUpdateRunning;

    public ProfileManager(String ownHash) {
        this.ownProfile = new LazyValue<Profile>(() -> this.lookupProfile(ownHash));
        this.startFriendsUpdater();
    }

    protected void startFriendsUpdater() {
        this.SCHEDULED_FRIEND_EXECUTOR.scheduleAtFixedRate(this::updateFriends, 10L, 60L, TimeUnit.SECONDS);
    }

    public abstract ChatState getChatState();

    public Profile getOwnProfile() {
        return this.ownProfile.get();
    }

    public void refreshOwnProfile() {
        Profile profile = this.getOwnProfile();
        profile.markStale();
        this.scheduleUpdate(profile);
    }

    public Profile lookupProfile(String hash) {
        Profile profile = this.lookupProfileStale(hash);
        if (profile.isStale() && !profile.isUpdating()) {
            this.scheduleUpdate(profile);
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile lookupProfileStale(String hash) {
        if (hash.isEmpty()) {
            throw new IllegalStateException("Empty hash provided. This should never happen!!");
        }
        Profile profile = this.profiles.get(hash);
        if (profile == null) {
            Map<String, Profile> map = this.profiles;
            synchronized (map) {
                String withoutMT;
                profile = this.profiles.get(hash);
                if (profile != null) {
                    return profile;
                }
                if (HashLength.FULL.matches(hash)) {
                    for (String alias : Profile.computeAllAliases(hash)) {
                        profile = this.profiles.get(alias);
                        if (profile == null) continue;
                        this.profiles.put(hash, profile);
                        return profile;
                    }
                }
                if (hash.charAt(0) == 'M' && (profile = this.profiles.get(withoutMT = hash.substring(2))) != null) {
                    this.profiles.put(hash, profile);
                    return profile;
                }
                profile = new Profile(this.getChatState(), hash);
                this.profiles.put(hash, profile);
                this.updateAliases(profile);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Profile> getKnownProfiles() {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            return StreamableIterable.of(this.profiles.values()).distinct().toImmutableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Profile> getMutedProfiles() {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            return StreamableIterable.of(this.profiles.values()).distinct().filter(Profile::isMuted).toImmutableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FriendRequest> getFriendRequests() {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            return ImmutableList.copyOf(this.friendRequests);
        }
    }

    public boolean sendFriendRequest(Profile to, String desiredName) {
        IrcUser ircUser = this.getChatState().ircClient.getUser(to);
        if (ircUser == null) {
            return false;
        }
        ircUser.sendFriendRequest(this.getOwnProfile().getFriendCode(), desiredName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyFriendRequest(FriendRequest request) {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            this.friendRequests.remove(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptFriendRequest(FriendRequest request, String desiredName) {
        IrcUser ircUser = this.getChatState().ircClient.getUser(request.from);
        if (ircUser == null) {
            return false;
        }
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            this.friendRequests.remove(request);
        }
        ircUser.acceptFriendRequest(this.getOwnProfile().getFriendCode(), request.desiredName);
        this.apiAcceptFriendRequest(request.friendCode, desiredName);
        return true;
    }

    public void onFriendRequestAccepted(Profile from, String friendCode, String desiredName) {
        this.fire(new ProfileManagerEvent(EventType.FRIEND_REQUEST_ACCEPTED, from));
        this.apiAcceptFriendRequest(friendCode, desiredName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIncomingFriendRequest(Profile from, String friendCode, String desiredName) {
        List<FriendRequest> list = this.friendRequests;
        synchronized (list) {
            FriendRequest request = new FriendRequest(from, friendCode, desiredName);
            this.friendRequests.add(request);
            this.fire(new ProfileManagerEvent(EventType.FRIEND_REQUEST_ADDED, request));
        }
    }

    public void apiAcceptFriendRequest(String friendCode, String desiredName) {
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                ApiResponse resp = this.getChatState().api.execute(new AddFriendRequest(this.getOwnProfile().getFullHash(), friendCode, desiredName)).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to remove friend. Api returned: {}", (Object)resp.getMessageOrNull());
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to add Friend.", (Throwable)ex);
            }
        });
    }

    private void updateFriends() {
        this.friendUpdateRunning = true;
        try {
            ListFriendsResponse resp = this.getChatState().api.execute(new ListFriendsRequest(this.getOwnProfile().getFullHash())).apiResponse();
            HashSet<String> friendHashes = new HashSet<String>();
            boolean changes = false;
            for (ListFriendsResponse.FriendEntry friend : resp.friends) {
                if (!HashLength.FULL.matches(friend.getHash())) {
                    LOGGER.warn("Ignoring friend '{}' with invalid hash. '{}'", (Object)friend.getName(), (Object)friend.getHash());
                    continue;
                }
                friendHashes.add(friend.getHash());
                if (!friend.isAccepted()) continue;
                Profile profile = this.lookupProfile(friend.getHash());
                profile.setFriend(friend.getName());
                changes = true;
            }
            for (Profile profile : this.getKnownProfiles()) {
                if (!profile.isFriend()) continue;
                if (ColUtils.anyMatch(profile.getAliases(), friendHashes::contains)) continue;
                profile.removeFriend();
                changes = true;
            }
            if (changes) {
                ++this.friendCookie;
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to query friend list.", ex);
        }
        this.friendUpdateRunning = false;
    }

    public int getFriendUpdateCookie() {
        return this.friendCookie;
    }

    public boolean isFriendUpdateRunning() {
        return this.friendUpdateRunning;
    }

    public void removeFriend(Profile friend) {
        friend.removeFriend();
        ++this.friendCookie;
        this.FRIEND_EXECUTOR.execute(() -> {
            try {
                ApiResponse resp = this.getChatState().api.execute(new RemoveFriendRequest(friend.getFriendCode(), this.getOwnProfile().getFullHash())).apiResponse();
                if (!resp.getStatus().equals("success")) {
                    LOGGER.error("Failed to remove friend. Api returned: {}", (Object)resp.getMessageOrNull());
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to remove friend!", (Throwable)ex);
            }
        });
    }

    public void onUserOnline(Profile profile) {
        if (profile.isOnline) {
            return;
        }
        profile.isOnline = true;
        if (profile.isFriend()) {
            this.fire(new ProfileManagerEvent(EventType.FRIEND_ONLINE, profile));
        }
    }

    public void onUserOffline(Profile profile) {
        if (!profile.isOnline) {
            return;
        }
        profile.isOnline = false;
        if (profile.isFriend()) {
            this.fire(new ProfileManagerEvent(EventType.FRIEND_OFFLINE, profile));
        }
    }

    private void scheduleUpdate(Profile profile) {
        Consumer<ProfileResponse.ProfileData> onFinished = profile.onStartUpdating().andThen(p -> this.updateAliases(profile));
        this.scheduleUpdate(profile, onFinished, 0);
    }

    private void scheduleUpdate(Profile profile, Consumer<ProfileResponse.ProfileData> onFinished, int depth) {
        this.PROFILE_EXECUTOR.execute(() -> {
            try {
                ProfileResponse resp = this.getChatState().api.execute(new ProfileRequest(profile.initialHash)).apiResponse();
                if (resp.getStatus().equals("success")) {
                    ProfileResponse.ProfileData data = resp.getData(profile.initialHash);
                    if (data == null) {
                        LOGGER.error("Profile response did not return expected hash. Got: '{}' Expected: {}", resp.getDataKeys(), (Object)profile.initialHash);
                    } else {
                        onFinished.accept(data);
                        return;
                    }
                }
                if (!resp.getMessage().startsWith("Profile request already ongoing")) {
                    LOGGER.warn("Unexpected error response from API: " + resp.getMessage());
                }
            }
            catch (IOException ex) {
                LOGGER.warn("IOException whilst querying profile.", (Throwable)ex);
            }
            this.SCHEDULED_EXECUTOR.schedule(() -> this.scheduleUpdate(profile, onFinished, depth + 1), (long)(depth + 1), TimeUnit.MINUTES);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAliases(Profile profile) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            for (String alias : profile.getAliases()) {
                Profile other;
                if (alias.equals(profile.initialHash) || (other = this.profiles.put(alias, profile)) == null || other == profile) continue;
                LOGGER.warn("Duplicate profiles with hash {}. A: {}, B: {}", (Object)alias, (Object)other.initialHash, (Object)profile.initialHash);
            }
        }
    }

    public static enum EventType {
        FRIEND_REQUEST_ADDED,
        FRIEND_REQUEST_ACCEPTED,
        FRIEND_ONLINE,
        FRIEND_OFFLINE;

    }

    public static class ProfileManagerEvent {
        public final EventType type;
        @Nullable
        public final Object data;

        public ProfileManagerEvent(EventType type, @Nullable Object data) {
            this.type = type;
            this.data = data;
        }
    }

    public static class FriendRequest {
        public final Profile from;
        public final String friendCode;
        public final String desiredName;

        public FriendRequest(Profile from, String friendCode, String desiredName) {
            this.from = from;
            this.friendCode = friendCode;
            this.desiredName = desiredName;
        }
    }
}

